<?php

/**
 * @package Helix_Ultimate_Framework
 * @author JoomShaper <support@joomshaper.com>
 * @copyright Copyright (c) 2010 - 2021 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined('_JEXEC') or die('Restricted Access');

use HelixUltimate\Framework\Platform\Helper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;


$data = $displayData;
$offcanvas_position = $displayData->params->get('offcanvas_position', 'right');
$menu_type = $displayData->params->get('menu_type');

$feature_folder_path = JPATH_THEMES . '/' . $data->template->template . '/features';

include_once $feature_folder_path . '/social.php';
include_once $feature_folder_path . '/contact.php';
include_once $feature_folder_path . '/logo.php';
include_once $feature_folder_path . '/menu.php';

/**
 * Helper classes for-
 * social icons, contact info, site logo, Menu header.
 *
 */
$social     = new HelixUltimateFeatureSocial($data->params);
$contact     = new HelixUltimateFeatureContact($data->params);
$logo        = new HelixUltimateFeatureLogo($data->params);
$menu        = new HelixUltimateFeatureMenu($data->params);

/** Logo and menu html classes */
$logoClass = 'col-auto';
$menuClass = 'col-auto flex-auto';

/**
 * Get related modules
 * The modules are mod_search
 */
$searchModule = Helper::getSearchModule();
$hederRight = ModuleHelper::getModules('header-right');
?>

<?php if ($displayData->params->get('sticky_header')) { ?>
<div class="sticky-header-placeholder"></div>
<?php } ?>
<div id="sp-top-bar">
    <div class="container">
        <div class="container-inner">
            <div class="row">
                <div id="sp-top1" class="col-5 col-sm-3">
                    <div class="sp-column">
                        <?php echo $social->renderFeature(); ?>
                        <jdoc:include type="modules" name="top1" style="sp_xhtml" />
                    </div>
                </div>

                <div id="sp-top2" class="col-7 col-sm-9">
                    <div class="sp-column d-flex justify-content-end align-items-center">
                        <?php echo $menu->renderFeature(); ?>
                        <jdoc:include type="modules" name="menu" style="sp_xhtml" />
                        <?php if ($data->params->get('enable_login', 0)): ?>
                        <?php echo $menu->renderLogin(); ?>
                        <?php endif ?>
                        <jdoc:include type="modules" name="top2" style="sp_xhtml" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<header id="sp-header">
    <div class="container">
        <div class="container-inner">
            <div class="row">
                <!-- Logo -->
                <div class="col-sm-12 col-md-4">
                    <div class="d-flex align-items-center">
                        <?php echo $logo->renderFeature(); ?>
                        <jdoc:include type="modules" name="logo" style="sp_xhtml" />
                    </div>
                </div>
                <div class="col-sm-12 col-md-8">
                    <div class="header-right">
                        <?php foreach ($hederRight as $module) {
                            echo ModuleHelper::renderModule($module, array('style' => 'sp_xhtml'));
                        } ?>
                    </div>
                </div>
            </div>
        </div>
</header>